unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons, Math, GraphXYv50;

type
  TForm1 = class(TForm)
    Panel3: TPanel;
    Label1: TLabel;
    ListBoxCoeff: TListBox;
    Panel5: TPanel;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Label13: TLabel;
    StaticTextCoffCount: TStaticText;
    Label14: TLabel;
    StaticTextMaxPower: TStaticText;
    StaticTextFileName: TStaticText;
    Label15: TLabel;
    SpButLoadCoeff: TSpeedButton;
    SpButSaveCoeff: TSpeedButton;
    Label2: TLabel;
    EditCoeff: TEdit;
    EditPower: TEdit;
    SpButAddCoeff: TSpeedButton;
    SpButEditCoeff: TSpeedButton;
    SpButDelCoeff: TSpeedButton;
    Label10: TLabel;
    EditX: TEdit;
    SpButCalcPolinom: TSpeedButton;
    Label11: TLabel;
    EditPolinom: TEdit;
    Panel4: TPanel;
    EditOp1: TEdit;
    EditOp2: TEdit;
    EditRes: TEdit;
    SpButPlus: TSpeedButton;
    SpButMinus: TSpeedButton;
    SpButMult: TSpeedButton;
    SpButDiv: TSpeedButton;
    SpButFunc: TSpeedButton;
    CbBoxSelFunc: TComboBox;
    Label3: TLabel;
    Label9: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    EditScale: TEdit;
    SpButPi: TSpeedButton;
    SpButE: TSpeedButton;
    CbBoxXbXeX: TComboBox;
    Label4: TLabel;
    PanelP: TPanel;
    Panel2: TPanel;
    Label5: TLabel;
    EditXB: TEdit;
    Label7: TLabel;
    EditXE: TEdit;
    EditNumP: TEdit;
    SpButCalcIntegral: TSpeedButton;
    Label8: TLabel;
    procedure ButtonAddClick(Sender: TObject);
    procedure ListBoxCoeffClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpButAddCoeffClick(Sender: TObject);
    procedure SpButEditCoeffClick(Sender: TObject);
    procedure SpButDelCoeffClick(Sender: TObject);
    procedure SpButCalcPolinomClick(Sender: TObject);
    procedure SpButSaveCoeffClick(Sender: TObject);
    procedure SpButLoadCoeffClick(Sender: TObject);
    procedure SpButPiClick(Sender: TObject);
    procedure SpButEClick(Sender: TObject);
    procedure SpButPlusClick(Sender: TObject);
    procedure SpButMinusClick(Sender: TObject);
    procedure SpButMultClick(Sender: TObject);
    procedure SpButDivClick(Sender: TObject);
    procedure SpButFuncClick(Sender: TObject);
    procedure SpButCalcIntegralClick(Sender: TObject);
  private
    //   ListBox
    procedure ShowListBoxParm();
    //     
    procedure ShowPolinomGraphic();
  public
end;

var
  Form1: TForm1;

//  Edit.Text  
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;

// =================================================================
// =================================================================
implementation
{$R *.dfm}
// =================================================================
// =================================================================

// =================================================================
//  
var GraphP    : TGraphXY;      //    
    ArrP      : TGraphArr;     //    

// =================================================================
//         
// =================================================================
// =================================================================
//      
// =================================================================
//  Edit.Text  
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;
begin
  Result := False;     //   
  try
    Val := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------------
//   ListBox
procedure TForm1.ShowListBoxParm();
begin
   StaticTextCoffCount.Caption := IntToStr(ListBoxCoeff.Count);
   if ListBoxCoeff.Count > 0
   then StaticTextMaxPower.Caption := IntToStr(ListBoxCoeff.Count -1)
   else StaticTextMaxPower.Caption := '0';
end;

// -----------------------------------------------------------------
//  Pi       
procedure TForm1.SpButPiClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditScale, Val)
  then begin
     case CbBoxXbXeX.ItemIndex of
     0 : EditOp1.Text := FloatToStr(Val * Pi);
     1 : EditOp2.Text := FloatToStr(Val * Pi);
     2 : EditX.Text   := FloatToStr(Val * Pi);
     end;
  end;
end;
// -----------------------------------------------------------------
//  Exp(1)       
procedure TForm1.SpButEClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditScale, Val)
  then begin
     case CbBoxXbXeX.ItemIndex of
     0 : EditOp1.Text := FloatToStr(Val * Exp(1));
     1 : EditOp2.Text := FloatToStr(Val * Exp(1));
     2 : EditX.Text   := FloatToStr(Val * Exp(1));
     end;
  end;
end;

// =================================================================
//       
// =================================================================
//   
procedure TForm1.ButtonAddClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditCoeff, Val)
  then begin
    ListBoxCoeff.Items.Add(EditCoeff.Text);
    ShowListBoxParm();
  end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.ListBoxCoeffClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    EditCoeff.Text := ListBoxCoeff.Items[ListBoxCoeff.ItemIndex];
    EditPower.Text := IntToStr(ListBoxCoeff.ItemIndex);
  end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButAddCoeffClick(Sender: TObject);
var Val : extended;
begin
  if Trim(EditCoeff.Text) = ''
  then begin
       MessageDlg('   .',
                   mtInformation,[mbYes],0);
       Exit;
  end;
  if EditToFloat (EditCoeff, Val)
  then begin
    ListBoxCoeff.Items.Add(EditCoeff.Text);
    ShowListBoxParm();
  end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButEditCoeffClick(Sender: TObject);
var Val : extended;
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    if EditToFloat (EditCoeff, Val)
    then begin
        ListBoxCoeff.Items[ListBoxCoeff.ItemIndex] := EditCoeff.Text;
    end;
  end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButDelCoeffClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    ListBoxCoeff.Items.Delete(ListBoxCoeff.ItemIndex);
    EditCoeff.Text := '';
    EditPower.Text := '';
    ShowListBoxParm();
  end;
end;
// -----------------------------------------------------------------
//     
function TryPolinomCalc(RqCoeff  : TListBox;
                        Argument : extended;
                    var Polinom  : extended) : boolean;
var Ind    : integer;
    WCoeff : extended;
    WPower : extended;
begin
    Result  := True;
    Polinom := 0;
    WPower  := 1;
    for Ind := 0 to RqCoeff.Count - 1
    do begin
       try
         WCoeff  := StrToFloat(RqCoeff.Items.Strings[Ind]);
         Polinom := Polinom + WCoeff * WPower;
         WPower  := WPower * Argument;
       except
         Result  := False;
       end;
       if not Result
       then begin
          ShowMessage('   ');
          Break;
       end;
    end;
end;
// -----------------------------------------------------------------
//      
procedure TForm1.SpButCalcPolinomClick(Sender: TObject);
var Argument, Polinom : extended;
begin
  if EditToFloat (EditX, Argument)
  then begin
     if TryPolinomCalc(ListBoxCoeff, Argument, Polinom)
     then EditPolinom.Text := FloatToStr(Polinom)
     else EditPolinom.Text := 'ERROR';
  end;
end;

// =================================================================
//      /     
// =================================================================
//     
procedure TForm1.SpButLoadCoeffClick(Sender: TObject);
var FileName : string;      //   
begin
   //  
   OpenDialog1.Filter := 'ListBox string files (*.lbx)|*.LBX';
   //   
   if OpenDialog1.Execute
   then begin
      //    ListBox
      FileName := OpenDialog1.FileName;
      ListBoxCoeff.Clear;
      ListBoxCoeff.Items.LoadFromFile(FileName);
      StaticTextFileName.Caption := ExtractFileName(FileName);
      ShowListBoxParm();
   end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButSaveCoeffClick(Sender: TObject);
var FileName,             //   
    FileExt : string;     //   
begin
  //  
  SaveDialog1.Filter := 'ListBox string files (*.lbx)|*.LBX';
  if Trim(StaticTextFileName.Caption) <> ''
  then SaveDialog1.FileName := StaticTextFileName.Caption
  else SaveDialog1.FileName := '  .lbx';
  //   
  if SaveDialog1.Execute
  then begin
     FileName := SaveDialog1.FileName;
     FileExt  := UpperCase(ExtractFileExt(FileName));
     //     ,    
     if not (FileExt = '.LBX') then FileName := FileName + '.lbx';
     //   
     if FileExists(FileName)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrYes
        then begin
           //   
           ListBoxCoeff.Items.SaveToFile(FileName);
           StaticTextFileName.Caption := ExtractFileName(FileName);
        end;
     end
     else begin
           //    
           ListBoxCoeff.Items.SaveToFile(FileName);
           StaticTextFileName.Caption := ExtractFileName(FileName);
     end;
  end;
end;

// =================================================================
//      
// =================================================================
//   
procedure TForm1.SpButPlusClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 + Op2;
       EditRes.Text := FloatToStr(Res);
    except
       EditRes.Text := '';
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
    end;
  end;
end;
//   
procedure TForm1.SpButMinusClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 - Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
//   
procedure TForm1.SpButMultClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 * Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
//   
procedure TForm1.SpButDivClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 / Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
//   
procedure TForm1.SpButFuncClick(Sender: TObject);
var Op1, Op2 : extended;
begin
  if CbBoxSelFunc.ItemIndex < 0 then Exit;
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       case CbBoxSelFunc.ItemIndex of
       //   
       0 : EditRes.Text := FloatToStr(Op1 * Op1);        // (Op1)
       1 : EditRes.Text := FloatToStr(Sqrt(Op1));        // (Op1)
       2 : EditRes.Text := FloatToStr(Power(Op1, Op2));  // Power(Op1, Op2)
       //   
       3 : EditRes.Text := FloatToStr(Exp(Op1));         // Exp (Op1)
       4 : EditRes.Text := FloatToStr(Ln(Op1));          // Ln(Op1)
       5 : EditRes.Text := FloatToStr(Log2(Op1));        // Log2(Op1)
       6 : EditRes.Text := FloatToStr(Log10(Op1));       // Log10(Op1)
       7 : EditRes.Text := FloatToStr(20*Log10(Op1));    // 20 * Log10(Op1)
       // 
       8 : EditRes.Text := FloatToStr(DegToRad(Op1));    // DegToRad (Op1)
       9 : EditRes.Text := FloatToStr(RadToDeg(Op1));    // RadToDeg (Op1)
      10 : EditRes.Text := FloatToStr(Sin(Op1));         // Sin(Op1)
      11 : EditRes.Text := FloatToStr(ArcSin(Op1));      // ArcSin(Op1)
      12 : EditRes.Text := FloatToStr(Cos(Op1));         // Cos(Op1)
      13 : EditRes.Text := FloatToStr(ArcCos(Op1));      // ArcCos(Op1)
      14 : EditRes.Text := FloatToStr(Tan(Op1));         // Tan(Op1)
      15 : EditRes.Text := FloatToStr(ArcTan(Op1));      // ArcTan(Op1)
      16 : EditRes.Text := FloatToStr(CoTan(Op1));       // CoTan(Op1)
      17 : EditRes.Text := FloatToStr(ArcCot(Op1));      // ArcCoTan(Op1)
      18 : EditRes.Text := FloatToStr(Sec(Op1));         // Sec(Op1)
      19 : EditRes.Text := FloatToStr(ArcSec(Op1));      // ArcSec(Op1)
      //  
      20 : EditRes.Text := FloatToStr(SinH(Op1));         // SinH(Op1)
      21 : EditRes.Text := FloatToStr(ArcSinH(Op1));      // ArcSinH(Op1)
      22 : EditRes.Text := FloatToStr(CosH(Op1));         // CosH(Op1)
      23 : EditRes.Text := FloatToStr(ArcCosH(Op1));      // ArcCosH(Op1)
      24 : EditRes.Text := FloatToStr(TanH(Op1));         // TanH(Op1)
      25 : EditRes.Text := FloatToStr(ArcTanH(Op1));      // ArcTanH(Op1)
      26 : EditRes.Text := FloatToStr(CotH(Op1));         // CoTanH(Op1)
      27 : EditRes.Text := FloatToStr(ArcCotH(Op1));      // ArcCoTanH(Op1)
      28 : EditRes.Text := FloatToStr(SecH(Op1));         // SecH(Op1)
      29 : EditRes.Text := FloatToStr(ArcSecH(Op1));      // ArcSecH(Op1)
        end;
    except
       MessageDlg('  '+ #13#10
                   + CbBoxSelFunc.Items[CbBoxSelFunc.ItemIndex],
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;

// =================================================================
//      
// =================================================================
// -----------------------------------------------------------------
//     
procedure TForm1.ShowPolinomGraphic();
const Delta = 1.e-20;
var  XB, XE  : extended;
     RNumP   : extended;
     INumP   : integer;
     X, dX   : extended;
     Y       : extended;
     Ind     : integer;
begin
  // ------------------------------------
  //   
  if ListBoxCoeff.Count < 1 then Exit;
  //   
  if not (EditToFloat (EditNumP, RNumP) and
          EditToFloat (EditXB, XB)      and
          EditToFloat (EditXE, XE))
  then Exit;
  //    
  INumP := Round(RNumP);
  if (XB >= XE) or (INumP <= 1) then Exit;
  // ------------------------------------
  //    
  dX  := (XE - XB) / INumP;
  SetLength(ArrP, INumP + 1);
  for Ind := Low(ArrP) to High(ArrP)
  do begin
     X := XB + Ind * dx;
     if TryPolinomCalc(ListBoxCoeff, X, Y)
     then begin
        ArrP[Ind].X := X;
        ArrP[Ind].Y := Y;
     end
     else begin
       SetLength(ArrP, 0);
       Exit;
     end;
  end;
  // ------------------------------------
  //  
  GraphP.FullEraseAreaXY;
  GraphP.ShowGraphXY(ArrP, RGB(0,127,0));
  // ------------------------------------
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButCalcIntegralClick(Sender: TObject);
begin
  ShowPolinomGraphic();
end;

// =================================================================
//      
// =================================================================
procedure TForm1.FormCreate(Sender: TObject);
begin
  ShowListBoxParm();
  GraphP := TGraphXY.Create(PanelP);    //  
  GraphP.GraphTitul := '  Y = P(X)';
end;
// -----------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
 GraphP.Free;
end;

// =================================================================
//    
// =================================================================



end.

